package pt.caf_pbs.schooldiskclient.dto;



import pt.caf_pbs.schooldiskclient.model.Instructor;
import pt.caf_pbs.schooldiskclient.model.SchoolInfo;
import pt.caf_pbs.schooldiskclient.model.Subject;

import java.util.ArrayList;
import java.util.List;

public class Mapper {
    public static SchoolInfo schoolInfoDTO2SchoolInfo(SchoolInfoDTO obj) throws NullPointerException {
        SchoolInfo data = null;
        data = new SchoolInfo(obj.getName(), obj.getVersion());
        return data;
    }
    public static Instructor instructorDTO2Instructor(InstructorDTO obj) throws NullPointerException {
        Instructor data = new Instructor(obj.getInitials(), obj.getName());
        return data;
    }

    public static List<Instructor> listInstructorDTO2listInstructor(List<InstructorDTO>  list) throws NullPointerException {
        List<Instructor> data = new ArrayList();
        for(InstructorDTO obj : list){
            Instructor i = instructorDTO2Instructor(obj);
            data.add(i);
        }
        return data;
    }
    public static InstructorDTO instructor2InstructorDTO(Instructor obj) throws NullPointerException {
        InstructorDTO data = new InstructorDTO(obj.getInitials(), obj.getName());
        return data;
    }

    public static Subject subjectDTO2Subject(SubjectDTO obj) throws NullPointerException {
        Subject data = new Subject(obj.getInitials(), obj.getDesignation());
        return data;
    }
    public static SubjectDTO subject2SubjectDTO(Subject obj) throws NullPointerException {
        SubjectDTO data = new SubjectDTO(obj.getInitials(), obj.getDesignation());
        return data;
    }
    public static LectureDTO subjectDTO2LectureDTO(SubjectDTO obj) throws NullPointerException {
        LectureDTO data = new LectureDTO(obj);
        return data;
    }

    public static List<Subject> listSubjectDTO2listSubject(List<SubjectDTO>  list) throws NullPointerException {
        List<Subject> data = new ArrayList();
        for(SubjectDTO obj : list){
            Subject i = subjectDTO2Subject(obj);
            data.add(i);
        }
        return data;
    }

    public static List<Subject> listLectureDTO2listSubject(List<LectureDTO>  list) throws NullPointerException {
        List<Subject> data = new ArrayList();
        for(LectureDTO obj : list){
            Subject i = subjectDTO2Subject(obj.getSubject());
            data.add(i);
        }
        return data;
    }

}
